package de.tfu.swing.tabelle;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

/**
 * TableColumnModel to react auf selection a table header.
 * @author Bastie - Sebastian Ritter
 */
public class BstTableColumnModel extends DefaultTableColumnModel {

  public void addColumn (final TableColumn aColumn) {
    super.addColumn(aColumn);
    this.addMyHeaderRenderer (aColumn);
  }

  /**
   * @param column
   */
  private void addMyHeaderRenderer(final TableColumn column) {
    column.setHeaderRenderer(new BstSelectionTableCellRenderer ());
  }
}
