package de.tfu.swing.tabelle;

import java.awt.*;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

/**
 * TableCellRenderer for select a column header.
 * @author Bastie - Sebastian Ritter
 * @version last tested with Java 1.5
 */
public class BstSelectionTableCellRenderer implements TableCellRenderer {

  private int pressedColumn = -1;
	
  public Component getTableCellRendererComponent (final JTable table,
                                                  final Object value,
                                                  final boolean isSelected,
                                                  final boolean hasFocus,
                                                  final int row,
                                                  final int column) {
    JLabel b = new JLabel ((value == null) ? "" : value.toString());
    // Dann stell das ganze mal richtig dar...

	  if (column == this.pressedColumn && column != 2) {
	  b.setBackground(UIManager.getColor("control"));
      b.setBorder(BorderFactory.createEtchedBorder(UIManager.getColor("controlHighlight"),UIManager.getColor("controlShadow")));
    }
    else {
      b.setBackground(UIManager.getColor("controlShadow"));
      b.setBorder(BorderFactory.createEtchedBorder(UIManager.getColor("controlLtHighlight"),UIManager.getColor("controlDkShadow")));
      }
	  b.setHorizontalAlignment(JLabel.CENTER);
    return b;
  }

  public void setPressedColumn (final int col) {
    this.pressedColumn = col;
  }
}
