package de.tfu.swing.tabelle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

/**
 * TableHeader for react on selection.
 * @author Bastie - Sebastian Ritter
 * @version last tested with Java 1.5
 */
public class BstJTableHeader extends JTableHeader implements MouseListener {

  public BstJTableHeader () {
    this (null);
  }
  public BstJTableHeader (final TableColumnModel columnModel) {
    super (columnModel);
    this.addMouseListener(this);
  }

  private ArrayList listener = new ArrayList();

  public void addActionListener (final ActionListener listener) {
    this.listener.add(listener);
  }

  public void removeActionListener (final ActionListener listener) {
    this.listener.remove(listener);
  }

  /**
   * Fire a ActionEvent with the table <strong>model</strong> column as
   * command.
   * @param column
   * @param when
   * @param modifiers
   */
  protected void fireActionEvent (final int column,
                                  final long when,
                                  final int modifiers) {
    final ActionEvent e = new ActionEvent (this,
                                     ActionEvent.ACTION_PERFORMED,
                                     ""+this.getTable()
                                            .getColumnModel()
                                            .getColumn(column)
                                            .getModelIndex(),
                                     when,
                                     modifiers);
    this.fireActionEvent(e);
  }
  protected void fireActionEvent (final ActionEvent e) {
    for (int i = 0; i < listener.size(); i++) {
      ((ActionListener)listener.get(i)).actionPerformed(e);
    }
  }

  /**
   * Method calls fireActionEvent with this table column of view.
   * @param e MouseEvent
   */
  public void mouseClicked (final MouseEvent e) {
    this.fireActionEvent(this.columnAtPoint(e.getPoint()),e.getWhen(),e.getModifiers());
  }

  public void mousePressed(MouseEvent e) {
    JTableHeader header = (JTableHeader) e.getSource();
    int column = header.columnAtPoint(e.getPoint());
    TableCellRenderer cr = header.getTable()
                                 .getColumnModel()
                                 .getColumn(column)
                                 .getHeaderRenderer();
    if (cr instanceof BstSelectionTableCellRenderer) {
      ((BstSelectionTableCellRenderer) cr).setPressedColumn(column);
      header.repaint();
    }
  }

  public void mouseReleased(MouseEvent e) {
    JTableHeader header = (JTableHeader) e.getSource();
    int column = header.columnAtPoint(e.getPoint());
    TableCellRenderer cr = header.getTable().getColumnModel().getColumn(column).getHeaderRenderer();
    if (cr instanceof BstSelectionTableCellRenderer) {
      ((BstSelectionTableCellRenderer) cr).setPressedColumn(-1);
	  header.repaint();
    }
  }

  public void mouseEntered(MouseEvent e) {}

  public void mouseExited(MouseEvent e) {}

}
