package de.tfu.swing.tabelle;

import java.util.logging.Logger;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.JTableHeader;

/**
 * Erweiterung der JTable um ntzlich Funktionen.
 * @author Bastie - Sebastian Ritter
 * @version last tested with Java 1.5
 */
public class BstJTable extends JTable {

  public BstJTable () {
    this (null, null);
  }

  public BstJTable (final TableModel model) {
    this (model, null);
  }

  /**
   * Do not use this Constructor because the TableColumnModel
   * is replacing.
   * @param model model that represents the business
   * @param columnModel <strong><i>is ignored</i></strong>
   * @param selectionModel how can users selected
   * @deprecated TableColumnModel is ignored. Better you use one of the simplifier constructors.
   */
  public BstJTable (final TableModel model,
                    final TableColumnModel columnModel,
                    final ListSelectionModel selectionModel) {
    this (model, selectionModel);
    Logger.getLogger(this.getClass().getName()).warning("TableColumnModel ignored - used constructor ist deprecated");
  }

  /**
   * Construct a new JTable with a selectable table header.
   * <br><i>All other constructors calls him.</i>
   * @param model model that represents the business
   * @param selectionModel how can users selected
   */
  public BstJTable (final TableModel model,
                    final ListSelectionModel selectionModel) {
    super (model, null, selectionModel);
    // Own ColumnModel
    this.setColumnModel(new BstTableColumnModel());
    // Own TableHeader
    this.setTableHeader(new BstJTableHeader());
    this.getTableHeader().setColumnModel(this.getColumnModel());
  }

  public JTableHeader getTableHeader () {
    return this.tableHeader;
  }

}
