/**
 * Created: 24.12.2006 01:23:54
 * Author: Michael Dempfle <mdempfle@mgm-edv.de>
 * File name: MyTableModel.java
 */
package de.tfu;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.table.AbstractTableModel;

/**
 * Beschreibung ...
 *
 * @author Michael Dempfle
 * @version $Id: MyTableModel.java 40 2007-02-13 22:25:32Z mdempfle $
 */
class MyTableModel extends AbstractTableModel {
	List gridFiles;
	ResourceBundle resourceBundle;
	JComboBox splitSizeCombo;
	long automaticSize;

	public final static Long[] steps;

	static {
		steps = new Long[]{new Long(500000), new Long(1000000),
				new Long(2000000), new Long(5000000), new Long(10000000)};
	}

	public MyTableModel(List gridFiles, ResourceBundle resourceBundle, JComboBox splitSizeCombo, long automaticSize) {
		this.gridFiles = gridFiles;
		this.resourceBundle = resourceBundle;
		this.splitSizeCombo = splitSizeCombo;
		this.automaticSize = automaticSize;
	}


	public String getColumnName(int col) {
		return resourceBundle.getString("cols." + col);
	}

	public int getColumnCount() {
		return 3;
	}

	public int getRowCount() {
		return (gridFiles != null) ? gridFiles.size() : 0;
	}

	public Object getValueAt(int row, int col) {
		if (col == 0) { // file name
			return ((File) gridFiles.get(row)).getName();
		} else if (col == 1) {
			int size = Math.round(((File) gridFiles.get(row)).length() / 1024);
			if (size == 0 && ((File) gridFiles.get(row)).length() > 0) {
				size = 1;
			}
			return size + resourceBundle.getString("bytes");
		} else {
			// we check the size to split
			String param = getSplitStatus(row);
			if (param.equals("n")) {
				return resourceBundle.getString(param);
			} else {
				return param;
			}
		}
	}

	public String getSplitStatus(int row) {
		int value = ((ComboBoxData) splitSizeCombo.getSelectedItem()).getValue();
		long size = automaticSize;
		if (value != 0) {
			size = (steps[value - 1]).longValue();
		}

		String param = "n";
		if ((((File) gridFiles.get(row)).length() > size)) {
			param = "" + (int) Math.ceil(((File) gridFiles.get(row)).length() / (double) size);
		}
		return param;
	}

	public int getSplitFiles() {
		int splitFiles = 0;
		if (gridFiles != null) {
			for (int i = 0; i < gridFiles.size(); ++i) {
				if (!getSplitStatus(i).equals("n")) {
					splitFiles++;
				}
			}
		}
		return splitFiles;
	}
}
