/**
 * Created: 12.01.2007 17:10:26
 * Author: Michael Dempfle <mdempfle@mgm-edv.de>
 * File name: MySortableTableModel.java
 */
package de.tfu;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Comparator;
import java.io.File;
import javax.swing.*;

/**
 * Beschreibung ...
 *
 * @author Michael Dempfle
 * @version $Id: MySortableTableModel.java 40 2007-02-13 22:25:32Z mdempfle $
 */
public class MySortableTableModel extends MyTableModel {

	public MySortableTableModel(List gridFiles, ResourceBundle resourceBundle, JComboBox splitSizeCombo, long automaticSize) {
		super(gridFiles, resourceBundle, splitSizeCombo, automaticSize);
	}

	public void sort(final int spalte) {
        if (this.gridFiles != null) {
		  Collections.sort(this.gridFiles, new FileComparator(spalte));
        }
	}


	private class FileComparator implements Comparator {
		private final int spalte;


		public FileComparator(final int spalte) {
			this.spalte = spalte;
		}


		public int compare(Object o1, Object o2) {
			if (o1 == null && o2 == null) {
				return 0;
			} else if (o1 == null) {
				return 1;
			} else if (o1 instanceof File && o2 instanceof File) {
				switch (this.spalte) {
					case 0:
						return ((File) o1).getName().compareToIgnoreCase(((File) o2).getName());   // alphabetical
					case 1:
						Long l1 = new Long(((File) o1).length());
						Long l2 = new Long(((File) o2).length());
						return l2.compareTo(l1); // biggest first
					default:
						return 0;
				}

			} else {
				return 1;
			}

		}

	}

}
