/**
 * Created: 22.12.2006 23:51:27
 * Author: Michael Dempfle <mdempfle@mgm-edv.de>
 * File name: MyCellRenderer.java
 */
package de.tfu;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.TableCellRenderer;

/**
 * Beschreibung ...
 *
 * @author Michael Dempfle
 * @version $Id: MyCellRenderer.java 40 2007-02-13 22:25:32Z mdempfle $
 */
public class MyCellRenderer implements TableCellRenderer {

	public Component getTableCellRendererComponent(
			JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

		JLabel label;
		if (!(value instanceof JLabel)) {
			label = new JLabel((String) value);
		} else {
			label = (JLabel) value;
		}
		label.setOpaque(true);
		label.setFont(table.getFont());
		label.setForeground(table.getForeground());
		label.setBackground(table.getBackground());

		if (isSelected) {
			label.setBackground(table.getSelectionBackground());
			label.setForeground(table.getSelectionForeground());
		}

		if (column == 0) {
			label.setText(" " + label.getText());
		}
		if (column == 1) {
			label.setHorizontalAlignment(JLabel.RIGHT);
			label.setText(label.getText() + " ");
		}
		if (column == 2) {
			label.setHorizontalAlignment(JLabel.CENTER);
		}
		return label;
	}
}
