package de.tfu;

/**
 * FileSplitApplet
 * @version $Id: FileSplitApplet.java 26 2007-01-22 14:12:48Z mdempfle $
 * $fsa_version: $    
 */

import de.tfu.swing.tabelle.BstJTable;
import de.tfu.swing.tabelle.BstJTableHeader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.*;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.*;
import javax.swing.*;

public class FileSplitApplet extends JApplet {
	private JPanel contentPane;                                              
	private JButton addFileSButton;
	private BstJTable gridTable;
	private JComboBox splitSizeCombo;
	private JButton buttonSelectDirectory;
	private JTextField targetDirectory;
	private JLabel status_text;
	private JTextField partTextField;
	private JButton splitButton;
	private JButton removeAllButton;
	private JScrollPane scrollPane;
	private JLabel title;
	private List gridFiles;
	private ResourceBundle resourceBundle;
	private static final String RESOURCES_FSA = "resources.fsa";
	MyTableModel dataModel;
	private JApplet ja;

	private long automaticSize = 102400; // 100k

	public FileSplitApplet() {
		ja = this;
		setContentPane(contentPane);
		addFileSButton.addActionListener(new ActionListener() {
			/** Invoked when an action occurs. */
			public void actionPerformed(ActionEvent e) {
				try {
					JFileChooser fc = new MyJFileChooser();

					fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
					fc.setMultiSelectionEnabled(true);
					fc.setDialogType(JFileChooser.OPEN_DIALOG);
					fc.setDragEnabled(true);
					int returnVal = fc.showOpenDialog(null);

					if (returnVal == JFileChooser.APPROVE_OPTION) {
						File[] newGridFiles = fc.getSelectedFiles();
						if (gridFiles == null) {
							gridFiles = new ArrayList(Arrays.asList(newGridFiles));

						} else {
							gridFiles.addAll(Arrays.asList(newGridFiles));
						}
						//messageFileName = messageFile.getAbsolutePath();
						//filenametext.setText(messageFileName);
						if (targetDirectory.getText().length() == 0) {
							targetDirectory.setText(((File) gridFiles.get(0)).getParent());
						}
						Set tempSet = new HashSet();
						tempSet.addAll(gridFiles);
						gridFiles = new ArrayList(tempSet);
						displayGrid();
					}
				} catch (AccessControlException ex) {
					status_text.setText("No rights to access the local file system!");
					throw ex;
				}
			}
		});
		splitSizeCombo.addActionListener(new ActionListener() {
			/** Invoked when an action occurs. */
			public void actionPerformed(ActionEvent e) {
				displayGrid();
			}
		});
		removeAllButton.addActionListener(new ActionListener() {
			/** Invoked when an action occurs. */
			public void actionPerformed(ActionEvent e) {
				if (gridFiles != null) {
					gridFiles.clear();
					displayGrid();
				}
			}
		});
		splitButton.addActionListener(new ActionListener() {
			/** Invoked when an action occurs. */
			public void actionPerformed(ActionEvent e) {
				status_text.setText(resourceBundle.getString("start.splitting"));
				splitButton.setEnabled(false);
				ja.update(ja.getGraphics());
				// we load all files and split them into chunks...
				for (int i = 0; i < gridFiles.size(); ++i) {
					if (!dataModel.getSplitStatus(i).equals("n")) { // we split!
						gridTable.getSelectionModel().setSelectionInterval(i, i);
						ja.update(ja.getGraphics());
						FileInputStream fis = null;
						try {
							File f = (File) gridFiles.get(i);
							fis = new FileInputStream(f);
							int buffersize = 100000; // 100k blcke
							byte[] buffer = new byte[buffersize];
							int value = ((ComboBoxData) splitSizeCombo.getSelectedItem()).getValue();
							long splitSize;
							if (value > 0) {
								splitSize = (MyTableModel.steps[value - 1]).longValue();
							} else {
								splitSize = automaticSize;
							}
							status_text.setText(MessageFormat.format(resourceBundle.getString("splitting.status"),
									new Object[]{formatDisplayName(f.getName()), new Integer(i + 1), new Integer(gridFiles.size())}));
							ja.update(ja.getGraphics());
							int parts = (int) Math.round(Math.ceil((double) f.length() / (double) splitSize));
							int section = 0;
							String tempText = status_text.getText();
							for (int j = 0; j < parts; ++j) {
								FileOutputStream fos = new FileOutputStream(targetDirectory.getText() + "/" + f.getName() + "." + partTextField.getText() + (j + 1));
								int subparts = (int) Math.round(Math.ceil(splitSize / buffersize));
								for (int jj = 0; jj < subparts; ++jj) {
									String prozent = " (" + 10 * (int) (10 * ((section++) / (parts * subparts * 1.0))) + "%)";
									status_text.setText(tempText + prozent);
									ja.update(ja.getGraphics());
									int read = fis.read(buffer, 0, buffersize);
									if (read > 0) {
										fos.write(buffer, 0, read);
									}
								}
								fos.flush();
								fos.close();
							}
						} catch (FileNotFoundException e1) {
							e1.printStackTrace();
						} catch (IOException e1) {
							e1.printStackTrace();
						} finally {
							if (fis != null) {
								try {
									fis.close();
								} catch (IOException e1) {
									// we don't care ...
								}
							}
						}
					}
				}
				gridFiles.clear();
				displayGrid();
				status_text.setText(resourceBundle.getString("all.files.splitted"));
			}
		});
		buttonSelectDirectory.addActionListener(new ActionListener() {
			/** Invoked when an action occurs. */
			public void actionPerformed(ActionEvent e) {
				// fileopener!
				try {
					JFileChooser fc = new MyJFileChooser();
					fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
					fc.setMultiSelectionEnabled(false);
					fc.setDialogType(JFileChooser.SAVE_DIALOG);
					int returnVal = fc.showOpenDialog(null);

					if (returnVal == JFileChooser.APPROVE_OPTION) {
						File targetDir = fc.getSelectedFile();
						try {
							targetDirectory.setText(targetDir.getCanonicalPath());
						} catch (IOException e1) {
							e1.printStackTrace();
						}
					}
				} catch (AccessControlException ex) {
					status_text.setText("No rights to access the local file system!");
					throw ex;
				}
			}
		});
		partTextField.addFocusListener(new FocusAdapter() {
			/** Invoked when a component loses the keyboard focus. */
			public void focusLost(FocusEvent e) {
				super.focusLost(e);
				if (partTextField.getText().length() == 0) {
					partTextField.setText("part");
					status_text.setText(resourceBundle.getString("prefix.not.empty"));
				}
			}
		});
	}

	private String formatDisplayName(String name) {
		if (name.length() > 15) {
			return name.substring(0, 15) + "...";
		}
		return name;
	}

	public void init() {
		super.init();
		scrollPane.setBackground(gridTable.getBackground());
		try {
			String str = getParameter("automaticSize");
			Long longVal = new Long(str);
			automaticSize = longVal.longValue() * 1024;
		} catch (NumberFormatException e) {
			System.out.println("Automatic size is not set! Default of 100k is used!");
		}

		Locale locale = Locale.getDefault();
		resourceBundle = ResourceBundle.getBundle(RESOURCES_FSA, locale);
		title.setText(title.getText() + " 0.5");
		ComboBoxData values[] = new ComboBoxData[6];
		for (int i = 0; i < 6; ++i) {
			String val = resourceBundle.getString("combo." + i);
			if (i == 0) {
				int value = (int) Math.floor(automaticSize / 1024);
				if (value < 1000) {
					val += " (" + value + " KB)";
				} else {
					val += " (" + (int) Math.floor(value / 1000) + " MB)";
				}
			}
			values[i] = new ComboBoxData(i, val);
		}
		ComboBoxModel cbModel = new DefaultComboBoxModel(values);

		splitSizeCombo.setModel(cbModel);

		((BstJTableHeader)gridTable.getTableHeader()).addActionListener(new SortTableActionListener (gridTable));
		displayGrid();
	}

	private void displayGrid() {
		// we display the grid
		dataModel = new MySortableTableModel(gridFiles, resourceBundle, splitSizeCombo, automaticSize);

		gridTable.setModel(dataModel);
		gridTable.getColumnModel().getColumn(0).setCellRenderer(new MyCellRenderer());
		gridTable.getColumnModel().getColumn(1).setCellRenderer(new MyCellRenderer());
		gridTable.getColumnModel().getColumn(2).setCellRenderer(new MyCellRenderer());
		gridTable.getColumnModel().getColumn(0).setPreferredWidth(240);
		gridTable.getColumnModel().getColumn(1).setPreferredWidth(80);
		gridTable.getColumnModel().getColumn(2).setPreferredWidth(50);

		//
		int splitFiles = dataModel.getSplitFiles();
		if (gridTable.getRowCount() > 0) {
			status_text.setText(MessageFormat.format(resourceBundle.getString("file.split.status"),
					new Object[]{new Integer(splitFiles), new Integer(dataModel.getRowCount())}));
			if (splitFiles > 0) {
				splitButton.setEnabled(true);
			}
		} else {
			status_text.setText(resourceBundle.getString("status.text"));
		}
	}
}
