<?php

defined( '_VALID_TWG' ) or die( 'Direct Access to this location is not allowed.' );

if (!checkFullscreen()) {
  $html5_upload_max_files = 1;
}

if (isset($_SESSION['twg_lang'])) {
    $default_language = $_SESSION['twg_lang'];
}
?>
<link rel="stylesheet" href="../plupload/js/jquery.ui.plupload/css/jquery-ui.css" type="text/css" />
<link rel="stylesheet" href="../plupload/js/jquery.ui.plupload/css/jquery.ui.plupload.css" type="text/css" />
<script type="text/javascript" src="../js/jquery-ui.min.js"></script>

<!-- production -->
<script type="text/javascript" src="../plupload/js/plupload.full.min.js"></script>
<script type="text/javascript" src="../plupload/js/jquery.ui.plupload/jquery.ui.plupload.min.js"></script>
<script type="text/javascript" src="../plupload/js/i18n/<?php echo $default_language; ?>.js"></script>

<style>
.plupload_wrapper {
    min-width: 240px;
}
.plupload_container {
    min-height: 340px;   
}
.plupload_add, .plupload_start, .plupload_stop {
   float:left;
}

td.plupload_file_name {
   white-space: normal;
}

.plupload_header_content {
padding-right: 60px;
}

.plupload_view_thumbs .plupload_file {
  margin-right: 5px;
}

@media only screen and (max-width: 460px) {
  .plupload_header_text {
    display:none;
  }
}

</style>
	<div id="uploader">
		<p>Your browser doesn't have Flash, Silverlight or HTML5 support.<br />If you use IE10/11 please disable the compatibility mode in your browser settings!</p>
	</div>
  <div id="console">
		</div>
<script type="text/javascript">
// Initialize the widget when the DOM is ready
jQuery(function() {
	jQuery("#uploader").plupload({
		// General settings
		runtimes : '<?php echo $html5_upload_runtimes; ?>',
		url : '../admin/upload/pl_upload.php',

		// User can upload no more then 100 files in one go (sets multiple_queues to false)
		max_file_count: <?php echo $html5_upload_max_files; ?>,
		
		chunk_size: '<?php echo $html5_upload_chunk_size; ?>',
		max_retries: <?php echo $html5_upload_retry; ?>,

    autostart : <?php echo $html5_upload_autostart; ?>,

		<?php if ($html5_upload_resize) { ?>
    // Resize images on clientside if we can
    resize : {
			width : <?php echo $html5_upload_resize_width; ?>,    
			height : <?php echo $html5_upload_resize_height; ?>, 
			quality : <?php echo $html5_upload_resize_quality; ?>,
			crop: <?php echo $html5_upload_resize_crop; ?> // crop to exact dimensions
		},
		<?php } ?>
		filters : {
			// Maximum file size
			max_file_size : '<?php echo $html5_upload_max_file_size; ?>',
			// Specify what files to browse for
			mime_types: [
				{title : "Supported files", extensions : "<?php echo $admin_user_allowed_file_extensions; ?>"}
			]
		},

		// Rename files by clicking on their titles
		rename: true,
		
		// Sort files
		sortable: true,

		// Enable ability to drag'n'drop files onto the widget (currently only HTML5 supports that)
		dragdrop: true,

		// Views to activate
		views: {
			list: true,
			thumbs: <?php echo $html5_upload_show_thumbs; ?>, // Show thumbs
			active: 'thumbs'
		},

		// Flash settings
		flash_swf_url : '../../js/Moxie.swf',
    
        // Post init events, bound after the internal events
    init : {
		
      FileUploaded: function(up, file, response) {
          // Called when file has finished uploading
          // log('[FileUploaded] File:', file, "Info:", response);
          
           var res = response.response;

           if ( res ) {
            var objResponse = jQuery.parseJSON( res );
            if ( objResponse.error )
            {
               up.stop();
               
               // not logged in
               if (objResponse.error.code == 104) {
                 var uploader = jQuery('#uploader').plupload('getUploader');
                 uploader.splice();
               }
               file.status = plupload.FAILED;
               up.trigger( 'Error', {
                  code:    objResponse.error.code,
                  message: objResponse.error.message,
                  details: file.name + ' failed',
                  file:    file
               } );

               return;
            }
            else
            {
            // Do stuff on success
            }
          }  
      },
      Error: function(up, args) {
          // Called when error occurs
          log('[Error] ', args);
      }
    } 
	});
});

    function log() {
        var str = "";
        <?php if ($html5_upload_debug) { ?>
        plupload.each(arguments, function(arg) {
            var row = "";
 
            if (typeof(arg) != "string") {
                plupload.each(arg, function(value, key) {
                    // Convert items in File objects to human readable form
                    if (arg instanceof plupload.File) {
                        // Convert status to human readable
                        switch (value) {
                            case plupload.QUEUED:
                                value = 'QUEUED';
                                break;
 
                            case plupload.UPLOADING:
                                value = 'UPLOADING';
                                break;
 
                            case plupload.FAILED:
                                value = 'FAILED';
                                break;
 
                            case plupload.DONE:
                                value = 'DONE';
                                break;
                        }
                    }
 
                    if (typeof(value) != "function") {
                        row += (row ? ', ' : '') + key + '=' + value;
                    }
                });
 
                str += row + " ";
            } else {
                str += arg + " ";
            }
        });
        if (console.log) {
            console.log(str);
        }
        <?php } ?>
    }
</script>
