<?php

umask(0000);
printHeader();
echo '
  <div id="ctr" align="center">
	<div class="install">
	<div id="step">Remove TinyWebGallery</div>
  <div class="clr"></div>
';
if (!file_exists("uninstall.sm.php")){
	echo "<span class=error>This uninstaller does remove TWG installations you cannot simply delete with your FTP program<br>because of missing permission and/or safemode restrictions.<br/>Before you start this please try to delete the installation with your FTP program.<br/>Only if this does not work use this uninstaller! <br/>&nbsp;<br/>Please make backups of all files you want to keep. I'm not responsible if you delete your data by mistake!</span>";

	echo '
  <h1>Step 1</h1>
	<div class="install-text">
	The uninstall.php is copied to uninstall.sm.php.<br/>
	<div class="ctr"></div></div>';

	echo '
  <div class="install-form">
  <div class="form-block">
  ';
	echo " This copy has to be done because the owner of the file is normally not your php user. By calling the copied file many safemode restrictions do not apply anymore.</div></div>";

	echo '<div class="clr"></div>';
	@copy ("uninstall.php", "uninstall.sm.php") ;
	if (file_exists("uninstall.sm.php")){
		echo '
	  <h1>Step 2</h1>
			<div class="install-text">
			The copy was successfull.<br/>Please call uninstall.sm.php by clicking on the button below.<br/>PLEASE NOTE: TWG will be deleted without further warnings!<br/>&nbsp;<br/><center><a class=button href="uninstall.sm.php">DELETE</a></center>
		<div class="ctr"></div></div>';
		echo '
		  <div class="install-form">
		  <div class="form-block">
	  ';

		echo "&nbsp;PLEASE NOTE: This can fail because of system restrictions or caching of the webserver:<br/>";
    echo "
			<ol>
					<li>If you get the message 'The requested URL ... was not found on this server.' - Press shift + Reload to reload the page.</li>
					<li>Try to call uninstall.sm.php directly!</li>
					<li>Otherwise call 'uninstall.php' again! (This would be Step 4!)</li>
			</ol>";
	}else{
		echo '
		  <h1>Copy failed!</h1>
				<div class="install-text">
				This does normally only happen when TWG is installed with the installer and located in the subdirectory twg. OR you can delete the files simply with your FTP program!<br/>
			<div class="clr"></div></div>';
		echo '
			  <div class="install-form">
			  <div class="form-block">
	  ';

		echo "<ol>
						<li>Check again if you cannot delete your files by changing the permission with your FTP program and delete the files and directory with it!</li> 
						<li>Please copy the uninstall.php to the directory one level higher if twg was installed by the installer!</li>
						<li>Check if the directory twg does exist there - otherwise the uninstaller tries to delete all files in this folder! Then call the file uninstall.php again! If not: DON'T</li>
						<li>If this does not help you can try to create an empty file called uninstall.sm.php and then call uninstall.php - if even this does not help this uninstaller cannot remove TWG (I haven't found a system yet where this was the case - please let me know if you have one!)</li>";
		echo "</ol>";
	}
	echo "</div></div>";
}else{
	if (substr($_SERVER['PHP_SELF'], -6) == "sm.php"){
		$step = 3;
	}else{
		$step = 5;
	}

	echo '
		  <div>
		  <h1>Step ' . $step . '</h1>
			<div class="install-text">
			The files/directories on the right side are deleted, are already deleted or cannot be read with the current permission.';
	if ($step = 3){
		echo 'Please proceed to step ' . ($step + 1) . '!<br/>';
	}
	echo '<div class="ctr"></div></div>';
	echo '
		  <div class="install-form">
		  <div class="form-block">
		  ';

	if (file_exists("twg")){
		remove_rec("twg");
		$rootdir = true;
	}else{
		$rootdir = false;
		remove_rec("admin");
		remove_rec("buttons");
		remove_rec("counter");
		remove_rec("cache");
		remove_rec("examples");
		remove_rec("html");
		remove_rec("i_frames");
		remove_rec("inc");
		remove_rec("joomla-mambo");
		remove_rec("js");
		remove_rec("language");
		remove_rec("language_extra");
		remove_rec("lightbox");
		remove_rec("picures");
		remove_rec("skins");
		remove_rec("xml"); 
		// delete all files exept uninstall ...
		echo "Delete the files in this folder";
		remove_files();
	}
	echo "</div></div>";
	echo "</div>";
	echo '<div class="clr"></div>';
	if (substr($_SERVER['PHP_SELF'], -6) == "sm.php" && !$rootdir){
		echo '
			<div>
			<h1>Step 4</h1>
				<div class="install-text">
				Lets now delete the remaining files by calling uninstall.php again.<br/>&nbsp;<br/><center><a class=button href="uninstall.php">DELETE REMAINING</a></center>
			<div class="ctr"></div></div>';
		echo '
			<div class="install-form">
			<div class="form-block">
	           ';
		echo "Depending on your permissions there can still be files left that normally could be deleted by your FTP program too.";
		echo "</div></div>";
		echo "</div>";
	}else{
		unlink("uninstall.sm.php");
		@unlink("uninstall.php");
		echo '<div class="clr"></div>';
		echo '
	  <div>
			<h1>Remove done!</h1>
			<div class="install-text">
			Uninstall finished. Please check if the files from TWG are deleted. You should be able to delete any remaining files with your FTP program.
			<div class="ctr"></div></div>';
	}
}
echo '<div class="clr"></div>';
echo "</div></div>";
printFooter();

function remove_files()
{
	if(($handle = opendir(".")) === false){
		echo "Main directory cannot be opend. Deletion of files not possible.<br/>";
	}while(($file = readdir($handle)) !== false){
		if(($file == ".." || $file == "." || $file == "uninstall.php" || $file == "uninstall.sm.php")) continue;

		if(!is_dir($file)){
			@chmod($file, 0777);
			clearstatcache();
			unlink($file);
		}
	}
	closedir($handle);
}

function remove_rec($item) // remove file / dir
{
	$ok = true;
	if (file_exists(realpath($item))){
		echo "Deleting folder '" . $item . "' ... <br/>";
		$item = realpath($item);
		if(is_link($item) || is_file($item)){
			@chmod($new_item, 0777);
			$ok = @unlink($item);
		}elseif(is_dir($item)){
			@chmod($item, 0777);
			clearstatcache();
			if(($handle = opendir($item)) === false){
				echo "Folder '" . $item . "' cannot be opend. Deletion not possible.<br/>";
			} while(($file = readdir($handle)) !== false){
				if(($file == ".." || $file == ".")) continue;

				$new_item = $item . "/" . $file;
				if(is_dir($new_item)){
					@chmod($new_item, 0777);
					$ok = remove_rec($new_item);
				}else{
					@chmod($new_item, 0777);
					clearstatcache();
					$ok = unlink($new_item);
				}
			}

			closedir($handle);
			@chmod($item, 0777);
			$ok = rmdir($item);
			if ($ok){
				echo "Folder '" . $item . "' deleted.<br/>&nbsp;<br/>";
			}else{
				echo "Folder '" . $item . "' NOT deleted.<br/>&nbsp;<br/>";
			}
		}
	}else{
		echo "Folder '" . $item . "' already deleted or cannot be read with the current permissions.<br/>";
	}
	return $ok;
}

function printHeader()
{
	global $safemode;

	echo "<?xml version=\"1.0\" encoding=\"iso-8859-15\"?" . ">";
	echo '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>TWG Uninstall</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-15" />

<style type="text/css" >
body { margin: 0px; padding: 0px; color : #333; background-color : #FFF; font-size : 11px; font-family : Arial, Helvetica, sans-serif; }
#step { font-size: 30px; font-weight: bold; text-align: left; color: #666666; padding: 10px 0px 20px 50px; white-space: nowrap; position: relative; float: left; }
.install { margin-left: auto; margin-right: auto; margin-top: 1em; margin-bottom: 1em; padding: 10px; border: 1px solid #cccccc; width: 750px; background: #F1F1F1; }
.install-small { margin-top: 10px; margin-bottom: 10px; margin-left: 10px; margin-right: 10px; padding: 10px; border: 1px solid #cccccc; width: 285px; height: 90%; vertical-align:middle; background: #F1F1F1; }
.install h1 { font-size: 15px; font-weight: bold; color: #c64934; padding: 10px 10px 4px 0px; text-align: left; border-bottom: 1px solid #c64934; margin-bottom: 10px; }
.install-form { position: relative; text-align: left; float: right; width: 69%; }
.install-text { position: relative; text-align: left; width: 30%; float: left; }
.form-block { border: 1px solid #cccccc; background: #E9ECEF; padding-top: 5px; padding-left: 5px; padding-bottom: 5px; padding-right: 5px; }
.left { position: relative; text-align: left; float: left; width: 50%; }
.right { position: relative; text-align: left; float: right; width: 50%; }
.far-right { position: relative; text-align: right; float: right; }
.clr { clear:both; }
.ctr { text-align: center; }
.button { border : solid 1px #cccccc; background: #E9ECEF; color : #666666; font-weight : bold; font-size : 11px; padding: 4px; cursor: pointer; }
.button2 { border : solid 2px #666666; background: #E9ECEF; color : #000000; font-weight : bold; font-size : 11px; padding: 4px; cursor: pointer; }
table.content { width: 90%; }
table.content td { color : #333333; font-size: 11px; vertical-align:top; }
td.item { width:150px; }
table.content2 { width: 90%; }
table.content2 td { color : #333333; font-size: 11px; }
.toggle { font-weight: bold; }
a { color: #C64934; text-decoration: none; }
a:hover { color : #30569D; text-decoration : underline; }
a:active { color : #FF9900; text-decoration : underline; }
.small { color : #333; font-size : 10px; }
.error { color : #cc0000; font-size : 12px; font-weight : bold; padding-top: 10px; padding-bottom: 10px; }
.green { color : #009900; font-size : 11px; font-weight : bold; padding-top: 10px; padding-bottom: 10px; }
.bold { font-size : 11px; font-weight : bold; }
select.options, input.options { font-size: 11px; border: 1px solid #999; }
form { margin: 0px 0px 0px 0px; }
.installheader { color : #FFF; font-size : 24px; }
</style>
</head>
<body>
';
}

function printFooter()
{
	echo "</body></html>";
}

?>