/*
 * Decompiled with CFR 0.152.
 */
package de.tfu;

import de.tfu.ComboBoxData;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

class MyTableModel
extends AbstractTableModel {
    List gridFiles;
    ResourceBundle resourceBundle;
    JComboBox splitSizeCombo;
    long automaticSize;
    public static final Long[] steps = new Long[]{new Long(500000L), new Long(1000000L), new Long(2000000L), new Long(5000000L), new Long(10000000L)};

    public MyTableModel(List gridFiles, ResourceBundle resourceBundle, JComboBox splitSizeCombo, long automaticSize) {
        this.gridFiles = gridFiles;
        this.resourceBundle = resourceBundle;
        this.splitSizeCombo = splitSizeCombo;
        this.automaticSize = automaticSize;
    }

    public String getColumnName(int col) {
        return this.resourceBundle.getString("cols." + col);
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.gridFiles != null ? this.gridFiles.size() : 0;
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return ((File)this.gridFiles.get(row)).getName();
        }
        if (col == 1) {
            int size = Math.round(((File)this.gridFiles.get(row)).length() / 1024L);
            if (size == 0 && ((File)this.gridFiles.get(row)).length() > 0L) {
                size = 1;
            }
            return size + this.resourceBundle.getString("bytes");
        }
        String param = this.getSplitStatus(row);
        if (param.equals("n")) {
            return this.resourceBundle.getString(param);
        }
        return param;
    }

    public String getSplitStatus(int row) {
        int value = ((ComboBoxData)this.splitSizeCombo.getSelectedItem()).getValue();
        long size = this.automaticSize;
        if (value != 0) {
            size = steps[value - 1];
        }
        String param = "n";
        if (((File)this.gridFiles.get(row)).length() > size) {
            param = "" + (int)Math.ceil((double)((File)this.gridFiles.get(row)).length() / (double)size);
        }
        return param;
    }

    public int getSplitFiles() {
        int splitFiles = 0;
        if (this.gridFiles != null) {
            for (int i = 0; i < this.gridFiles.size(); ++i) {
                if (this.getSplitStatus(i).equals("n")) continue;
                ++splitFiles;
            }
        }
        return splitFiles;
    }
}

