/*
 * Decompiled with CFR 0.152.
 */
package de.tfu.swing.tabelle;

import de.tfu.swing.tabelle.BstSelectionTableCellRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class BstJTableHeader
extends JTableHeader
implements MouseListener {
    private ArrayList listener = new ArrayList();

    public BstJTableHeader() {
        this(null);
    }

    public BstJTableHeader(TableColumnModel columnModel) {
        super(columnModel);
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener listener) {
        this.listener.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listener.remove(listener);
    }

    protected void fireActionEvent(int column, long when, int modifiers) {
        ActionEvent e = new ActionEvent(this, 1001, "" + this.getTable().getColumnModel().getColumn(column).getModelIndex(), when, modifiers);
        this.fireActionEvent(e);
    }

    protected void fireActionEvent(ActionEvent e) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((ActionListener)this.listener.get(i)).actionPerformed(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.fireActionEvent(this.columnAtPoint(e.getPoint()), e.getWhen(), e.getModifiers());
    }

    public void mousePressed(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        int column = header.columnAtPoint(e.getPoint());
        TableCellRenderer cr = header.getTable().getColumnModel().getColumn(column).getHeaderRenderer();
        if (cr instanceof BstSelectionTableCellRenderer) {
            ((BstSelectionTableCellRenderer)cr).setPressedColumn(column);
            header.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        int column = header.columnAtPoint(e.getPoint());
        TableCellRenderer cr = header.getTable().getColumnModel().getColumn(column).getHeaderRenderer();
        if (cr instanceof BstSelectionTableCellRenderer) {
            ((BstSelectionTableCellRenderer)cr).setPressedColumn(-1);
            header.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

