/*
 * Decompiled with CFR 0.152.
 */
package de.tfu;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import de.tfu.ComboBoxData;
import de.tfu.MyCellRenderer;
import de.tfu.MyJFileChooser;
import de.tfu.MySortableTableModel;
import de.tfu.MyTableModel;
import de.tfu.SortTableActionListener;
import de.tfu.swing.tabelle.BstJTable;
import de.tfu.swing.tabelle.BstJTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FileSplitApplet
extends JApplet {
    private JPanel contentPane;
    private JButton addFileSButton;
    private BstJTable gridTable;
    private JComboBox splitSizeCombo;
    private JButton buttonSelectDirectory;
    private JTextField targetDirectory;
    private JLabel status_text;
    private JTextField partTextField;
    private JButton splitButton;
    private JButton removeAllButton;
    private JScrollPane scrollPane;
    private JLabel title;
    private List gridFiles;
    private ResourceBundle resourceBundle;
    private static final String RESOURCES_FSA = "resources.fsa";
    MyTableModel dataModel;
    private JApplet ja;
    private long automaticSize;

    public FileSplitApplet() {
        this.$$$setupUI$$$();
        this.automaticSize = 102400L;
        this.ja = this;
        this.setContentPane(this.contentPane);
        this.addFileSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MyJFileChooser fc = new MyJFileChooser();
                    fc.setFileSelectionMode(0);
                    fc.setMultiSelectionEnabled(true);
                    fc.setDialogType(0);
                    fc.setDragEnabled(true);
                    int returnVal = fc.showOpenDialog(null);
                    if (returnVal == 0) {
                        File[] newGridFiles = fc.getSelectedFiles();
                        if (FileSplitApplet.this.gridFiles == null) {
                            FileSplitApplet.this.gridFiles = new ArrayList<File>(Arrays.asList(newGridFiles));
                        } else {
                            FileSplitApplet.this.gridFiles.addAll(Arrays.asList(newGridFiles));
                        }
                        if (FileSplitApplet.this.targetDirectory.getText().length() == 0) {
                            FileSplitApplet.this.targetDirectory.setText(((File)FileSplitApplet.this.gridFiles.get(0)).getParent());
                        }
                        HashSet tempSet = new HashSet();
                        tempSet.addAll(FileSplitApplet.this.gridFiles);
                        FileSplitApplet.this.gridFiles = new ArrayList(tempSet);
                        FileSplitApplet.this.displayGrid();
                    }
                }
                catch (AccessControlException ex) {
                    FileSplitApplet.this.status_text.setText("No rights to access the local file system!");
                    throw ex;
                }
            }
        });
        this.splitSizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSplitApplet.this.displayGrid();
            }
        });
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FileSplitApplet.this.gridFiles != null) {
                    FileSplitApplet.this.gridFiles.clear();
                    FileSplitApplet.this.displayGrid();
                }
            }
        });
        this.splitButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void actionPerformed(ActionEvent e) {
                FileSplitApplet.this.status_text.setText(FileSplitApplet.this.resourceBundle.getString("start.splitting"));
                FileSplitApplet.this.splitButton.setEnabled(false);
                FileSplitApplet.this.ja.update(FileSplitApplet.this.ja.getGraphics());
                for (int i = 0; i < FileSplitApplet.this.gridFiles.size(); ++i) {
                    if (FileSplitApplet.this.dataModel.getSplitStatus(i).equals("n")) continue;
                    FileSplitApplet.this.gridTable.getSelectionModel().setSelectionInterval(i, i);
                    FileSplitApplet.this.ja.update(FileSplitApplet.this.ja.getGraphics());
                    FileInputStream fis = null;
                    File f = (File)FileSplitApplet.this.gridFiles.get(i);
                    fis = new FileInputStream(f);
                    int buffersize = 100000;
                    byte[] buffer = new byte[buffersize];
                    int value = ((ComboBoxData)FileSplitApplet.this.splitSizeCombo.getSelectedItem()).getValue();
                    long splitSize = value > 0 ? MyTableModel.steps[value - 1] : FileSplitApplet.this.automaticSize;
                    FileSplitApplet.this.status_text.setText(MessageFormat.format(FileSplitApplet.this.resourceBundle.getString("splitting.status"), FileSplitApplet.this.formatDisplayName(f.getName()), new Integer(i + 1), new Integer(FileSplitApplet.this.gridFiles.size())));
                    FileSplitApplet.this.ja.update(FileSplitApplet.this.ja.getGraphics());
                    int parts = (int)Math.round(Math.ceil((double)f.length() / (double)splitSize));
                    int section = 0;
                    String tempText = FileSplitApplet.this.status_text.getText();
                    for (int j = 0; j < parts; ++j) {
                        FileOutputStream fos = new FileOutputStream(FileSplitApplet.this.targetDirectory.getText() + "/" + f.getName() + "." + FileSplitApplet.this.partTextField.getText() + (j + 1));
                        int subparts = (int)Math.round(Math.ceil(splitSize / (long)buffersize));
                        for (int jj = 0; jj < subparts; ++jj) {
                            String prozent = " (" + 10 * (int)(10.0 * ((double)section++ / ((double)(parts * subparts) * 1.0))) + "%)";
                            FileSplitApplet.this.status_text.setText(tempText + prozent);
                            FileSplitApplet.this.ja.update(FileSplitApplet.this.ja.getGraphics());
                            int read = fis.read(buffer, 0, buffersize);
                            if (read <= 0) continue;
                            fos.write(buffer, 0, read);
                        }
                        fos.flush();
                        fos.close();
                    }
                    Object var20_20 = null;
                    if (fis == null) continue;
                    try {
                        fis.close();
                    }
                    catch (IOException e12) {}
                    continue;
                    {
                        catch (FileNotFoundException e1) {
                            e1.printStackTrace();
                            var20_20 = null;
                            if (fis == null) continue;
                            try {
                                fis.close();
                            }
                            catch (IOException e12) {}
                            continue;
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            var20_20 = null;
                            if (fis == null) continue;
                            try {
                                fis.close();
                            }
                            catch (IOException e12) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var20_20 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e12) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                FileSplitApplet.this.gridFiles.clear();
                FileSplitApplet.this.displayGrid();
                FileSplitApplet.this.status_text.setText(FileSplitApplet.this.resourceBundle.getString("all.files.splitted"));
            }
        });
        this.buttonSelectDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MyJFileChooser fc = new MyJFileChooser();
                    fc.setFileSelectionMode(1);
                    fc.setMultiSelectionEnabled(false);
                    fc.setDialogType(1);
                    int returnVal = fc.showOpenDialog(null);
                    if (returnVal == 0) {
                        File targetDir = fc.getSelectedFile();
                        try {
                            FileSplitApplet.this.targetDirectory.setText(targetDir.getCanonicalPath());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                catch (AccessControlException ex) {
                    FileSplitApplet.this.status_text.setText("No rights to access the local file system!");
                    throw ex;
                }
            }
        });
        this.partTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (FileSplitApplet.this.partTextField.getText().length() == 0) {
                    FileSplitApplet.this.partTextField.setText("part");
                    FileSplitApplet.this.status_text.setText(FileSplitApplet.this.resourceBundle.getString("prefix.not.empty"));
                }
            }
        });
    }

    private String formatDisplayName(String name) {
        if (name.length() > 15) {
            return name.substring(0, 15) + "...";
        }
        return name;
    }

    public void init() {
        super.init();
        this.scrollPane.setBackground(this.gridTable.getBackground());
        try {
            String str = this.getParameter("automaticSize");
            Long longVal = new Long(str);
            this.automaticSize = longVal * 1024L;
        }
        catch (NumberFormatException e) {
            System.out.println("Automatic size is not set! Default of 100k is used!");
        }
        Locale locale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle(RESOURCES_FSA, locale);
        this.title.setText(this.title.getText() + " 0.5");
        ComboBoxData[] values = new ComboBoxData[6];
        for (int i = 0; i < 6; ++i) {
            String val = this.resourceBundle.getString("combo." + i);
            if (i == 0) {
                int value = (int)Math.floor(this.automaticSize / 1024L);
                val = value < 1000 ? val + " (" + value + " KB)" : val + " (" + (int)Math.floor(value / 1000) + " MB)";
            }
            values[i] = new ComboBoxData(i, val);
        }
        DefaultComboBoxModel<ComboBoxData> cbModel = new DefaultComboBoxModel<ComboBoxData>(values);
        this.splitSizeCombo.setModel(cbModel);
        ((BstJTableHeader)this.gridTable.getTableHeader()).addActionListener(new SortTableActionListener(this.gridTable));
        this.displayGrid();
    }

    private void displayGrid() {
        this.dataModel = new MySortableTableModel(this.gridFiles, this.resourceBundle, this.splitSizeCombo, this.automaticSize);
        this.gridTable.setModel(this.dataModel);
        this.gridTable.getColumnModel().getColumn(0).setCellRenderer(new MyCellRenderer());
        this.gridTable.getColumnModel().getColumn(1).setCellRenderer(new MyCellRenderer());
        this.gridTable.getColumnModel().getColumn(2).setCellRenderer(new MyCellRenderer());
        this.gridTable.getColumnModel().getColumn(0).setPreferredWidth(240);
        this.gridTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.gridTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        int splitFiles = this.dataModel.getSplitFiles();
        if (this.gridTable.getRowCount() > 0) {
            this.status_text.setText(MessageFormat.format(this.resourceBundle.getString("file.split.status"), new Integer(splitFiles), new Integer(this.dataModel.getRowCount())));
            if (splitFiles > 0) {
                this.splitButton.setEnabled(true);
            }
        } else {
            this.status_text.setText(this.resourceBundle.getString("status.text"));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        BstJTable bstJTable;
        JScrollPane jScrollPane;
        JButton jButton2;
        JButton jButton3;
        JTextField jTextField;
        JComboBox jComboBox;
        JButton jButton4;
        JTextField jTextField2;
        JLabel jLabel2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(6, 1, new Insets(0, 10, 5, 10), -1, -1, false, false));
        jPanel.setAutoscrolls(true);
        ((Component)jPanel).setBackground(new Color(-1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-3355444)), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-1));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("resources/fsa").getString("status"));
        Font font = jLabel3.getFont();
        jLabel3.setFont(new Font(font.getName(), 1, font.getSize()));
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.status_text = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/fsa").getString("status.text"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.targetDirectory = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("resources/fsa").getString("split.file.size"));
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("resources/fsa").getString("target.directory"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.buttonSelectDirectory = jButton4 = new JButton();
        jButton4.setText("...");
        jPanel2.add((Component)jButton4, new GridConstraints(1, 2, 1, 1, 0, 0, 3, 0, new Dimension(25, 20), new Dimension(25, 20), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-1));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.splitSizeCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("resources/fsa").getString("split.prefix"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.partTextField = jTextField = new JTextField();
        jTextField.setText("part");
        jPanel3.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 4, 0, 6, 0, null, new Dimension(50, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setBackground(new Color(-1));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        this.removeAllButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("resources/fsa").getString("remove"));
        jPanel4.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.addFileSButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("resources/fsa").getString("add.files"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, new Dimension(70, -1), null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("resources/fsa").getString("files.to.split"));
        jPanel.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.scrollPane = jScrollPane = new JScrollPane();
        ((Component)jScrollPane).setEnabled(true);
        ((Component)jScrollPane).setBackground(new Color(-1));
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.gridTable = bstJTable = new BstJTable();
        bstJTable.setAutoResizeMode(2);
        bstJTable.setShowVerticalLines(true);
        bstJTable.putClientProperty("Table.isFileList", new Boolean(false));
        jScrollPane.setViewportView(bstJTable);
        this.splitButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("resources/fsa").getString("split"));
        ((Component)jButton).setEnabled(false);
        jPanel.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        this.title = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/fsa").getString("title"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

