<?php
/**
 * TWG Flash uploader 3.2.x
 *
 * Copyright (c) 2004-2014 TinyWebGallery
 * written by Michael Dempfle
 *
 * Name: Watermark plugin
 * Description: This plugin creates a watermark on each uploaded image. Please set the parameters in the plugin to change the settings.
 * Version Plugin: 1.0
 * Needed flash version: 3.0 
 *  
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU in the next version!  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/**
 *  
 **/
function watermark_plugin_process_upload_file($folder, $fullpath ,$filename) {

  $watermark = "watermark.png";        // (String) The file name of the watermark image. 
  $watermark_dir = dirname(__FILE__) . "/"; // The directory of the watermark. By default it is the one where watermark_plugin.php is located
  $compression = 80;                   // (Number) quality of the generated jpegs - best = 100 - but biggest size !! Don't use % here!
  $position= 7;                        // (Number) You can define the location of the watermark with this setting (top:  1  2  3, middle: 4  5  6, bottom: 7  8  9
  $transparency= 70;                   // (Number) You can also set the transparency of your logo. 0 is no transparency - 100 max; Try your logo with different settings to get best results. For 24 bit pngs with alphachannel please use 0 because then the alpha transparency is used!
	$t_x= 0;                             // (Number) The next two settings define the position of a transparent color in your watermark.
	$t_y= 0;                             // (Number) If your logo has e.g. a white border you can set the values to 0:0 and the border will be transparent. If you don't want a transparent color: set these values to -1!
  
  if (is_supported_tfu_image( $fullpath, $fullpath)) { 
    $watermark_full = $watermark_dir . $watermark;
    $size = getImageSize($fullpath);
    $im = loadImage($fullpath, $size[2]);
    watermark($im, $watermark_full, $size[0],$size[1], $size[2], $position, $transparency, $t_x,$t_y);
    store_image($im, $fullpath, $size[2], $compression);
  }
}


function watermark($dst, $watermark, $width, $heigth, $info, $position, $transparency, $t_x,$t_y)
{
    $infos_img[0] = $width;
    $infos_img[1] = $heigth;
    $infos_img[2] = $info;

    if ($position < 1 || $position > 9) {
        tfu_debug("Wrong position of the watermark - no watermark is rendered on the image!");
        return false;
    }
    if (!file_exists($watermark)) {
        tfu_debug("Watermark " . $watermark . " not found - no watermark is rendered on the image!");
        return false;
    }
    $infos_wat = getimagesize($watermark);
    if (!in_array($infos_img[2], array(1, 2, 3)) || !in_array($infos_wat[2], array(1, 2, 3))) {
        tfu_debug("Wrong type of the watermark  - no watermark is rendered on the image!");
        return false;
    }
    if ($infos_img[0] < $infos_wat[0] || $infos_img[1] < $infos_wat[1]) {
        tfu_debug("watermark is too big  - no watermark is rendered on the image!!");
        return false;
    }
    if ($infos_wat[0] < $t_x || $infos_wat[1] < $t_y) {
        tfu_debug("watermark is too big  - no watermark is rendered on the image!");
        return false;
    }
    $transparency = 100 - $transparency;
    if ($transparency < 0 || $transparency > 100) {
        tfu_debug("transparency is out of range - image is not created!");
        return false;
    }
    // Position x
    switch (($position - 1) % 3) {
        case 0:
            $pos_x = 0;
            break;
        case 1:
            $pos_x = round(($infos_img[0] - $infos_wat[0]) / 2, 0);
            break;
        case 2:
            $pos_x = $infos_img[0] - $infos_wat[0];
            break;
    }
    // Position y
    switch (floor(($position - 1) / 3)) {
        case 0:
            $pos_y = 0;
            break;
        case 1:
            $pos_y = round(($infos_img[1] - $infos_wat[1]) / 2, 0);
            break;
        case 2:
            $pos_y = $infos_img[1] - $infos_wat[1];
            break;
    }
    $img_image = $dst;

    $img_watermark = loadImage($watermark, $infos_wat[2]);
    imagealphablending($img_image, true);
    imagealphablending($img_watermark, true);
    if ($t_x != -1) {
        imagecolortransparent($img_watermark, imagecolorat($img_watermark, $t_x, $t_y));
    }
    if ($transparency == 100) {
       imagecopy($img_image, $img_watermark, $pos_x, $pos_y, 0, 0, $infos_wat[0], $infos_wat[1]);
    } else {
       imagecopymerge($img_image, $img_watermark, $pos_x, $pos_y, 0, 0, $infos_wat[0], $infos_wat[1], $transparency);
    }
    return $img_image;
}

function loadImage($image, $image_type)
{ // image needs ~ twice the memory of the image!
    set_error_handler("on_error_no_output");
    if ($image_type == 3) { // PNG
        $src = @imagecreatefrompng($image);
    } else if ($image_type == 1) {
        $src = @imagecreatefromgif($image);
    } else if ($image_type == 2) { // valid jpeg
        $src = @imagecreatefromjpeg($image);
    } else { // invalid jpeg
        $src = @imagecreatefromjpeg($image); // we try to open an invalid file!
    }
    set_error_handler("on_error");
    if (!$src) {
        tfu_debug('\'' . $image . '\' could not loaded properly. Please check if the file is corrupt.');
    }
    return $src;
}

function store_image($im, $name, $image_type, $compression, $close = true)
{
    if ($image_type == 3) { // PNG
        if ($name != '') {
            $result = imagepng($im, $name);
        } else {
            $result = imagepng($im);
        }
    } else if ($image_type == 1) { // GIF
        if ($name != '') {
            $result = imagegif($im, $name);
        } else {
            $result = imagegif($im);
        }
    } else {
        $result = imagejpeg($im, $name, $compression);
    }
    if ($result && $close) {
        imagedestroy($im);
    }
    return $result;
}
?>