<?php
/**
 * TWG Flash uploader 2.11.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 * 
 * Name: Unzip plugin  
 * Description: This plugin extracts zip files right after the upload. The requirements for this plugin are PHP 5 >= 5.2.0 or PECL zip >= 1.1.0. You can do the following settings in the unzip_plugin.php: 1. Zip files are deleted right after the upload. 2. The files are extracted to the upload directory or the file name is used as unzip directory. If your server does not provide the needed classes a message is shown in the log file.
 * Version Plugin: 1.0
 * Needed flash version: 2.11  
 *
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU in the next version!  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/**
 * Unzip plugin 
 **/
function unzip_plugin_process_upload_file($folder, $fullpath ,$filename) {

  $delete_file_after_upload = false;   // true/false Deletes the file after the upload
  $extract_to_here = false;            // true/false true: extract the zip to the upload folder; false: uses the filename as unzip directory.

  if (class_exists('ZipArchive') ) {
    $ext = strtolower(substr($filename, strrpos($filename, '.') + 1));
    if ($ext == 'zip') {
      // unzip the file to the current dir or to a subdir!!
      $zip = new ZipArchive();
      if ($zip->open($fullpath) === TRUE) {
        if ($extract_to_here) {
          $zipdir = dirname($fullpath);
        } else {
          $zipdir = dirname($fullpath) . '/' . basename(strtolower($filename),".zip"); 
          mkdir($zipdir);
        } 
        $zip->extractTo($zipdir);
        $zip->close();
        if ($delete_file_after_upload) {
          @unlink($fullpath);
        } 
      }
    }
  } else {
    tfu_debug('The class ZipArchive does not exist. Please make sure you use PHP 5 >= 5.2.0 or PECL zip >= 1.1.0.');
  }
}
?>