<?php
/**
 * TWG Flash uploader 2.10.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 * 
 * Description: This plugin deletes files if they are older than x days or if more than y files are in the upload folder. Please edit the parameters in cleanup_plugin.php to configure this plugin.
 *
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU in the next version!  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/**

 *  
 **/
function cleanup_plugin_process_upload_file($folder, $fullpath ,$filename) {
    global $exchangefilename, $dir_chmod;
    
    $days=        30;    // If a file is older than $days it will be deleted
    // set the values below to really high values if you only want to delete old files.
    $file_limit = 1000;    // If more than $file_limit files are in one folder the oldest ones are deleted until only $files_min are left. 
    $files_min =  1000;    // See $file_limit
    $excludefiles = '.htaccess,readme.txt';  // This files are NOT deleted.
    
    //
    // Only edit something below this line if you know what you do
    //
    $filesanddirs = get_dir($_SESSION['TFU_ROOT_DIR']);
    $excludelist = explode(',', $excludefiles);
    $files = array();
    $timedif = time() - ($days*86400);
    
    foreach($filesanddirs as $file) {
      if (!is_dir($file) && !in_array(basename($file), $excludelist)) {
        $time = filemtime($file);
        if ($time < $timedif) {
          @unlink($file);
        } else {
          $files[] = sprintf("%10s_", $time ) . $file;  // we add the time for sorting!  
        }     
      }
    } 
    rsort($files);
    if (count($files) > $file_limit) {
      $rest = array_slice($files,0,count($files)-$files_min);
      foreach ($rest as $f) {
        @unlink(substr($f,11));
      }   
    } 
}

/*
Gets all files of a directory and its sub directories.
*/
 function get_dir($myDir = '.')
{
    global $exclude_directories;
    $dir = opendir($myDir);
    $counter = 0;
    $dirlist = array();
    $filelist = array();
    while ($file = readdir($dir)) {
        $dirlist[] = $file;
    }
    foreach ($dirlist as $file) {
        $newDir = $myDir . '/' . $file;
        if ($file == '.' || $file == '..')
            continue;

        if (is_dir($newDir)) {
          $filelist = array_merge ($filelist, get_dir($newDir));
        } else {
          $filelist[] = $newDir;
        }
    }
    return $filelist;
} 


?>