<?php
/**
 * TWG Flash uploader 2.11.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 * 
 * Name: Prefix plugin 
 * Description: This plugin adds a prefix to each uploaded file. Please check the code for the different options. The default prefix is a date in the format year-month-day. 
 * Version Plugin: 1.0
 * Needed flash version: 2.11 
 *
 * Feel free to adopt this to your needs.  
 * Please provide the 4 info lines above if you make your own plugin!
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/**

 *  
 **/
function a_prefix_plugin_process_upload_file($folder, $fullpath ,$filename) {
global $exchangefilename;


$username = (isset($_SESSION['TFU_USER'])) ? $_SESSION['TFU_USER'] : $_SERVER['REMOTE_ADDR']; 

// Next 3 values are only available if you use Joomla and a user is registered
$userid =          (isset($_SESSION['TFU_USER_ID']))    ? ' | ' . $_SESSION['TFU_USER_ID']    : ''; 
$userdisplayname = (isset($_SESSION['TFU_USER_NAME']))  ? ' | ' . $_SESSION['TFU_USER_NAME']  : ''; 
$useremail =       (isset($_SESSION['TFU_USER_EMAIL'])) ? ' | ' . $_SESSION['TFU_USER_EMAIL'] : ''; 

// Here you find how the formating is done: http://de.php.net/manual/en/function.date.php
// Make sure not to use anythink like ':' in the date - some file systems do not like this and browsers have problem downloading such files.
$currenttime = date("Ymd"); 

// here you can set which prefix is used! a couple are available on top - choose one you like or create your own ...
$prefix = $currenttime;
// in exchangefilename the new filename is passed back to tfu_upload.php
$exchangefilename = dirname($fullpath) . '/' . $prefix . '_' . $filename;
rename($fullpath, $exchangefilename);

}
?>