<?php
/**
 * TWG Flash uploader 2.11.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 * 
 * Name: File log plugin
 * Description: The log plugin logs the most important actions of the flash to the file tfu.log. You can use this plugin as an example for own plugins how to get the different events of flash.
 * Version Plugin: 1.1
 * Needed flash version: 2.11 
 *  
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU in the next version!  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/*
  This function is called direclty by the tfu_upload.php or by log_plugin_process_file
*/
function log_plugin_process_upload_file($folder, $fullpath ,$filename, $type = "upload") {

$username = (isset($_SESSION['TFU_USER'])) ? $_SESSION['TFU_USER'] : $_SERVER['REMOTE_ADDR']; 

// Next 3 values are only available if you use Joomla and a user is registered
$userid =          (isset($_SESSION['TFU_USER_ID']))    ? ' | ' . $_SESSION['TFU_USER_ID']    : ''; 
$userdisplayname = (isset($_SESSION['TFU_USER_NAME']))  ? ' | ' . $_SESSION['TFU_USER_NAME']  : ''; 
$useremail =       (isset($_SESSION['TFU_USER_EMAIL'])) ? ' | ' . $_SESSION['TFU_USER_EMAIL'] : ''; 

// check if the encoding is right for you !
$description =     (isset($_GET['description']))        ? ' | ' . utf8_decode($_GET['description']) : ''; 
$filesize = file_exists($fullpath) ? filesize($fullpath) : 0 ;
$currenttime = date("d.m.Y"); // not used here because the debug function already adds a timestamp.

/* remove unwanted ../ from the path because they are only needed because tfu is in such a deep directory structure  */
$folder = str_replace("../", "", $folder);
$fullpath =  str_replace("../", "", $fullpath);

// this is the debug function of TFU - the output is written to tfu.log. Values are seperated by |
tfu_debug($type . ' | ' . $username . ' | ' .  $folder . ' | ' . $fullpath . ' | ' . $filename .  ' | ' . $filesize . $userid . $userdisplayname . $useremail. $description);
}

/*
  This function is called when the tfu_file.php is called. e.g. for delete, download ...
*/
function log_plugin_process_file($action, $file, $folder) {
   // you can add all possible actions here 
  if ($action == "download" || $action == "zipdownload" || $action == "savetext" ||  
      $action == "delete" || $action == "xdelete" || $action == "createfile") {
    if ($action == "createfile") {
      $file = $folder . "/" . parseInputParameterFile(trim(my_basename(' ' . $_GET['newfile'])));
    }
    if (is_array($file)) {
      foreach ($file as $ff) {
        log_plugin_process_upload_file($folder, $ff ,basename($ff), $action);
      }
    } else {
      log_plugin_process_upload_file($folder, $file ,basename($file), $action);
    }
  } else if ($action == "renamedir" || $action == "deletedir" || $action == "createdir") {
    if ($action != "deletedir") { 
      $file = parseInputParameterFile(trim(my_basename(' ' . $_GET['newdir'])));  
    }
    log_plugin_process_upload_file($folder, '', $file, $action);  
  } else if ($action == "copymove") {
    // only from/to as tracked - for more details (like copy or move) you have to extend this by yourself! 
    $dest = getDestinationFolder(parseInputParameter($_GET['target'])); 
    foreach ($file as $ff) {
      log_plugin_process_upload_file($folder, $ff, $dest , $action);
    }
  }
}


/* To be compatible to old versions of TFU */
if (!function_exists('tfu_debug')) { function tfu_debug($str) { debug($str); } }
?>