<?php
/**
 * TWG Flash uploader 2.16.x
 *
 * Copyright (c) 2004-2012 TinyWebGallery
 * written by Michael Dempfle
 *
 * Name: E-mail plugin
 * Description: This is the e-mail plugins of TFU - Please check the big documentation in the readme.
 * Version Plugin: 1.1
 * Needed flash version: 2.14
 *
 * Feel free to adopt this to your needs.
 *
 * Options you can add by yourself:
 * - option to attach file.
 * - option to send e-mail for each file or only a summary!
 * - smtp server!!
 * If you implement something like this please give it back to the community 
 *  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

$mail_type=''; // don't change this!
/**
 *
 **/
function email_plugin_process_upload_file($folder, $fullpath ,$filename) {
  global $remaining, $email_plugin, $fix_utf8,$mail_type;
  global $upload_notification_email_from, $upload_notification_email, $upload_notification_email_subject;
  $email_plugin = true; // disables the default e-mail

  $send_2nd_mail = false; // set this to true to enable the 2nd e-mail

  // This are the options you can use for the pattern. Please only use the ones you like.
  // {id} = id of the db plugin - only available if the db plugin is used!
  // {filename} = file name only
  // {file} = file name with folder - when you set $upload_notification_use_full_path this variable is extended to the full url 
  // {description} = uploaded description in the description mode 
  // {size} = size of the uploaded file
  $list_pattern = '{id} : {file} : {description} : {size}';

  if ($remaining == 0) { // only send the e-mail for the last uploaded file.
  // e-mail 1
  // this data is mainly read from the TFU configuration
  $mail_from=$upload_notification_email_from; // from the configuration
  $mail_to=$upload_notification_email; // from the configuration
  // The subject from the TFU configuration where the placeholders are replaced
  $mail_subject= fillTemplate('', $folder, $fullpath ,$filename, $list_pattern, $upload_notification_email_subject);
  $mail_text_template='email_template_config.txt'; // the template for this e-mail.
  $mail_text = fillTemplate($mail_text_template, $folder, $fullpath ,$filename, $list_pattern);
  send_email($mail_from,$mail_to,$mail_subject,$mail_text,$mail_type,$fix_utf8);

  // This is the 2nd e-mail which can be sent to someone else. By default it is send to the Joomla user if available
  
  // if you like a different subject set $upload_notification_email_subject again.
  $useremail = (isset($_SESSION['TFU_USER_EMAIL'])) ?  $_SESSION['TFU_USER_EMAIL'] : '';
  // If you like that the e-mail is sent to a differnt e-mail simply define it here.
    if ($send_2nd_mail && $useremail != '') {
      $mail_from=$upload_notification_email_from; // from the configuration
      $mail_to=$useremail; // by default the Joomla user that uploaded the file 
       // The subject from the TFU configuration where the placeholders are replaced
      $mail_subject= fillTemplate('', $folder, $fullpath ,$filename, $list_pattern, $upload_notification_email_subject);
      $mail_text_template='email_template_user.html';  // the template for this e-mail.
      $mail_text = fillTemplate($mail_text_template, $folder, $fullpath ,$filename, $list_pattern);
      send_email($mail_from,$mail_to,$mail_subject,$mail_text,$mail_type,$fix_utf8);
    }
  
    // remove the ids from the session
    if (isset($_SESSION['last_ids'])) {
      unset($_SESSION['last_ids']);
    }     
  } 
}

//
//
//   ONLY MODIFY SOMETHING BELOW HERE IF YOU REALLY KNOW WHAT YOU DO!
//
//
/**
 *  $type = text/plain or text/html
 */
function send_email($mail_from, $mail_to, $subject, $mailtext, $type, $fix_utf8) {

        $submailheaders = "From: $mail_from\n";
        $submailheaders .= "Reply-To: $mail_from\n";
        $submailheaders .= "Return-Path: $mail_from\n";
        if ($fix_utf8 != '') {
          $submailheaders .= 'Content-Type: '.$type.'; charset=' . $fix_utf8 . "\n";
        } else {
          $submailheaders .= 'Content-Type: '.$type.'; charset=UTF-8' . "\n";
        }
        if ($type=="text/plain") {
          @mail ($mail_to, html_entity_decode ($subject), html_entity_decode ($mailtext), $submailheaders);
        } else {
          $submailheaders .= "MIME-Version: 1.0\n";
          @mail ($mail_to, html_entity_decode ($subject), $mailtext, $submailheaders);
        }
}

function fillTemplate($mail1_text_template, $folder, $fullpath , $filename, $list_pattern, $data = '') {
global $mail_type, $upload_notification_use_full_path, $description_mode;
global $upload_notification_email_from, $upload_notification_email, $path_fix;

if ($mail1_text_template != '') {
  // read the template
  if (file_exists($mail1_text_template)) {
    $data = file_get_contents($mail1_text_template,1);
    if (substr ($data,0,1) == '<') { // html
      $mail_type = 'text/html';
    } else {
      $mail_type='text/plain';
    }
  } else {
    $data = "The specified e-mail template '".$mail1_text_template."' cannot be found. Please check your settings.";
  }
}
// last files excluding the current ($fullpath)
$_SESSION['TFU_LAST_UPLOADS'];
// last description of ($fullpath)
$description =     (isset($_GET['description']))        ?  utf8_decode($_GET['description']) : '';
$last_file = ($description == '') ? $fullpath : $fullpath . ' : ' . $description;
$filelist = $_SESSION['TFU_LAST_UPLOADS'];
$filelist[] = $last_file;
$username = (isset($_SESSION['TFU_USER'])) ? $_SESSION['TFU_USER'] : $_SERVER['REMOTE_ADDR'];
// Next 3 values are only available if you use Joomla and a user is registered
$userid =          (isset($_SESSION['TFU_USER_ID']))    ?  $_SESSION['TFU_USER_ID']    : '';
$userdisplayname = (isset($_SESSION['TFU_USER_NAME']))  ?  $_SESSION['TFU_USER_NAME']  : '';
$useremail =       (isset($_SESSION['TFU_USER_EMAIL'])) ?  $_SESSION['TFU_USER_EMAIL'] : '';
$currenttime = date("d.m.Y");
$nr_files = count ($filelist);

// unwanted path is removed
$folder = str_replace("../", "", $folder);
$fullpath =  str_replace("../", "", $fullpath);
$folder = str_replace("..", "", $folder);
$fullpath =  str_replace("..", "", $fullpath);

$filestr = '';
$filestr_html = '';
$filestr_ul = '<ul>';

$last_id='';
$last_filename='';
$last_file='';
$last_description='';
$last_size='';

foreach ($filelist as $filename) {
      if ($description_mode == 'true') {
         // get the description if set ' : '
        $teile = explode(" : ", $filename);
        if (count($teile) > 1) {
           $current_desc = $teile[1];
           $current_file = $teile[0];
        } else {
           $current_desc = '';
           $current_file = $filename;
        }
      } else {
        $current_desc = '';
        $current_file = $filename;
      }
      $size = formatSize(filesize($current_file));
      
      if ($upload_notification_use_full_path) {
        $cfilest =  space_enc(fixUrl(getRootUrl() . $path_fix . $current_file)) ;
      } else {
        $cfilest =  str_replace('./', '', str_replace('../', '', $current_file));
      }
      
      // unwanted path is removed
      $current_file =  str_replace("../", "", $current_file);
      $current_file =  str_replace("..", "", $current_file);
      
      // replace the 4 possiblilities.
      $list_content = str_replace("{file}", $cfilest, $list_pattern);
      $last_file = $cfilest;
      if (isset($_SESSION['last_ids'])) {
        $id_db = $_SESSION['last_ids'][$current_file]; 
        $list_content = str_replace("{id}", $id_db, $list_content);
        $last_id = $id_db;
      } else {
        $list_content = str_replace("{id} : ", '', $list_content);
      }
      
      $list_content = str_replace("{filename}", basename($cfilest), $list_content);
      $last_filename = basename($cfilest);
      if ($description_mode == 'true') {
        $list_content = str_replace("{description}", $current_desc, $list_content);
        $last_description = $current_desc;
      } else {
        $list_content = str_replace(" : {description}", '', $list_content);
      }
      
      $list_content = str_replace("{size}", $size, $list_content);
      $last_size = $size;
      $filestr .=  $list_content .  "\n";
      $filestr_html .= $list_content . '<br>';
      $filestr_ul .= '<li>' . $list_content . '</li>';
}
$filestr_ul .=  '</ul>';
$filestr = trim($filestr); // remove the last \n
// now we do the replacements
$data = str_replace("{emailfrom}", $upload_notification_email, $data);
$data = str_replace("{emailto}", $upload_notification_email_from, $data);
$data = str_replace("{username}", $username, $data);
$data = str_replace("{userid}", $userid, $data);
$data = str_replace("{userdisplayname}", $userdisplayname, $data);
$data = str_replace("{useremail}", $useremail, $data);
$data = str_replace("{currenttime}", $currenttime, $data);
$data = str_replace("{folder}", $folder, $data);
$data = str_replace("{nrfiles}", $nr_files, $data);
$data = str_replace("{filelist}", $filestr, $data);
$data = str_replace("{htmlfilelist}", $filestr_html, $data);
$data = str_replace("{ulfilelist}", $filestr_ul, $data);
$data = str_replace("{last_id}", $last_id, $data);
$data = str_replace("{last_filename}", $last_filename, $data);
$data = str_replace("{last_file}", $last_file, $data);
$data = str_replace("{last_description}", $last_description, $data);
$data = str_replace("{last_size}", $last_size, $data);

return $data;
}
?>