<?php
/**
 * TWG Flash uploader 2.11.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 *
 * Name: Download Move plugin
 * Description: This plugin moves a file after a download to a fix folder. By default this folder name is 'archive'. Please modify the variable $userdir to your needs!
 * Version Plugin: 1.0
 * Needed flash version: 2.11 
 *  
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU!  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/*
  This function is called when the tfu_file.php is called. e.g. for delete, download ...
*/
function download_move_plugin_process_file($action, $filename, $folder) {
  // needed to set the new download
  global $file, $dir_chmod;
  
  if ($action == "download") {  
    $archivedir = 'archive';
    $relfolder =  dirname(substr($filename, strlen($_SESSION['TFU_ROOT_DIR'])+1));  
    $newfolder = $_SESSION['TFU_ROOT_DIR'] . '/' . $archivedir . '/' . $relfolder;
    $exchangefilename = $newfolder . '/' . basename($filename);  
    
    // if the file is already in the archive folder we don't do anything.
    if ($archivedir == substr($relfolder, 0, strlen($archivedir))) {
      return;
    }

    if (!file_exists($newfolder)) {
      $result = mkdir_recursive($newfolder);
      if ($result && $dir_chmod != 0) {
        @chmod($newfolder, $dir_chmod);
      }
    }
    
    // If the file exists and the source is not the destinaion we delete the old one and move the file   
    if (file_exists($exchangefilename)) {
      @unlink($exchangefilename);
    }
    // we move the file and set the new destination for the download if the move was successfull
    if (@rename($filename, $exchangefilename)) {
      $file = $exchangefilename;
    }
    
    // we check if the folder is empty and delete it if it is.
    // only . and .. are returned.
    if (count(scandir($folder)) == 2) {  
      rmdir($folder);
    }
  }
 
}

function mkdir_recursive($pathname) {
    is_dir(dirname($pathname)) || mkdir_recursive(dirname($pathname));
    return is_dir($pathname) || twg_mkdir($pathname);
}

function twg_mkdir($dir, $permissions = false) {
  $main_dir = dirname($dir);
  if (file_exists($main_dir) && is_writeable($main_dir)) {
    if ($permissions) {
       return @mkdir($dir, $permissions);
    } else {
       return @mkdir($dir); 
    }
  } else {
    return false;
  }
}



?>