<?php
/**
 * TWG Flash uploader 2.17.x
 *
 * Copyright (c) 2004-2012 TinyWebGallery
 * written by Michael Dempfle
 *
 * Name: Download delete plugin
 * Description: This plugin deletes the file/s after a download. Additional an e-mail can be sent if you enter an e-mail for the upload notification. Please modify the text for the e-mail in the plugin file.
 * Version Plugin: 1.0
 * Needed flash version: 2.1 
 *  
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU!  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/*
  This function is called when the tfu_file.php is called. e.g. for delete, download ...
*/
function download_delete_plugin_after_process_file($action, $file, $folder) {
  // needed to set the new download
  global $file, $dir_chmod, $upload_notification_email, $upload_notification_email_from;
  global $upload_notification_use_full_path;
  
  $path_fix = '';
  if (isset($_SESSION['IS_ADMIN']) || isset($_SESSION['IS_FRONTEND'])) { // for JFU
    $path_fix = '../';
  }
  
  if ($action == "download" || $action == "zipdownload") {   
    // If the file exists we delete it
    if (is_array($file)) {
       foreach ($file as $ff) {
         @unlink($ff);
       }
     } else {
       @unlink($file);
     }
    // download e-mail notification is enabled when upload notification is enabled.
    if ($upload_notification_email != '') {
        $youremail = $upload_notification_email_from;
        $email = $upload_notification_email;
        $submailheaders = "From: $youremail\n";
        $submailheaders .= "Reply-To: $youremail\n";
        $submailheaders .= "Return-Path: $youremail\n"; 
        $username = (isset($_SESSION['TFU_USER'])) ? $_SESSION['TFU_USER'] : $_SERVER['REMOTE_ADDR'];
        $files = is_array($file) ? $file : array($file);        
        $filestr = '';
        foreach ($files as $filename) {
          if ($upload_notification_use_full_path) {
            $filestr .= space_enc(fixUrl(getRootUrl() . $path_fix . $filename));
          } else {  
            $filestr .= str_replace('./', '', str_replace('../', '', $filename));
          }
          $filestr .= "\n";
        }
        if (is_array($file)) {
          $subject = count($file) . 'Files where downloaded and deleted after the download.';        
        } else {
          $subject = 'A file was downloaded and deleted after the download.';       
        }
        $mailtext = 'The following files where downloaded and deleted after the download by ' . $username . ":\n" . $filestr;
        
        @mail ($email, html_entity_decode ($subject), (html_entity_decode ($mailtext)), $submailheaders);
    }
  }
}
?>