<?php
/**
 * TWG Flash uploader 2.11.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 *
 * Name: Database log plugin 
 * Description: This plugin logs all important actions to a database called <prefix>joomla_flash_uploader_log. This plugin is mandatory of you want to use the database viewer plugin.
 * Version Plugin: 1.2
 * Needed flash version: 2.11 
 *   
 * Feel free to adopt this to your needs.  
 * The description line is shown in the backend of JFU in the next version!   
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/*
  This function is called directly by the tfu_upload.php or by log_plugin_process_file
*/
function db_plugin_process_upload_file($folder, $fullpath ,$filename, $type = "upload") {

// if you use this in joomla 1.5 the values from joomla are used.
$joomla_config =  dirname(__FILE__) . "/../../../../configuration.php";
if (file_exists($joomla_config)) {
  include_once $joomla_config; 
  // we check if joomla 1.5.x or 1.0.x
  if (class_exists("JConfig")) { // 1.5.x
    $jConfig = new JConfig();
    $db_host = $jConfig->host;
    $db_user = $jConfig->user;
    $db_password = $jConfig->password;
    $db_dbname = $jConfig->db;
    $db_table = $jConfig->dbprefix . 'joomla_flash_uploader_log';
  } else { //1.0.x
    $db_host = $mosConfig_host;
    $db_user = $mosConfig_user;
    $db_password = $mosConfig_password;
    $db_dbname = $mosConfig_db;
    $db_table = $mosConfig_dbprefix . 'joomla_flash_uploader_log';
  }
} else {
  // enter your db values below!
  $db_host = 'localhost';
  $db_user = 'root';
  $db_password = '';
  $db_dbname = 'joomla15';
  $db_table = 'joomla_flash_uploader_log';
}

$username = (isset($_SESSION['TFU_USER'])) ? $_SESSION['TFU_USER'] : $_SERVER['REMOTE_ADDR']; 

// Next 3 values only available if you use Joomla and a user is registered
$userid =          (isset($_SESSION['TFU_USER_ID']))    ? $_SESSION['TFU_USER_ID']    : ''; 
$userdisplayname = (isset($_SESSION['TFU_USER_NAME']))  ? $_SESSION['TFU_USER_NAME']  : ''; 
$useremail =       (isset($_SESSION['TFU_USER_EMAIL'])) ? $_SESSION['TFU_USER_EMAIL'] : ''; 
// check if the encoding is right for you ! see the log plugin for not using utf-8
$description =     (isset($_GET['description']))        ? $_GET['description'] : ''; 
$size = file_exists($fullpath) ? filesize($fullpath) : 0 ;

/* remove unwanted ../ from the path because they are only needed because tfu is in such a deep directory structure  */
$folder = str_replace("../", "", $folder);
$fullpath =  str_replace("../", "", $fullpath);

// because of the sql_save_mode 2 ways to connect to the db are tried!
set_error_handler('on_error_no_output'); // I disable the error handler because outputs can cause other parts of TFU to fail!
$db_connection = @mysql_connect($db_host,$db_user,$db_password);
if (!$db_connection) {
    $db_connection = @mysql_connect(); 
    if (!$db_connection) {    
      tfu_debug('No connection to db possible - please check your settings and if sql_safe_mode is disabled. Error: ' . mysql_error());
      set_error_handler('on_error');
      return;
    }
}
set_error_handler('on_error');

if (function_exists('mysql_set_charset')) {
  mysql_set_charset('utf8',$db_connection);
}
$db_database   = mysql_select_db($db_dbname);
// once the table is created you can remove this part if you like!
$table_sql = 'CREATE TABLE IF NOT EXISTS ' . $db_table . ' (
                id INT NOT NULL AUTO_INCREMENT,    
                username TEXT,                  
                userid TEXT,
                userdisplayname TEXT,
                useremail TEXT,
                filename TEXT,
                folder TEXT,
                fullpath TEXT, 
                description TEXT,
                uploadtime TIMESTAMP,  
                PRIMARY KEY (id) )';      
mysql_query($table_sql,$db_connection) or tfu_debug ('Couldn\'t create table ' . $db_table);
// new columns are added seperately to update existing log files
add_column_if_not_exist($db_connection, $db_table, 'action', 'TEXT');
add_column_if_not_exist($db_connection, $db_table, 'size', 'BIGINT');

// now we insert the data:
$query = sprintf("INSERT INTO " . $db_table . " (`action`,`username`, `userid`,`userdisplayname`, `useremail`,`filename`,`folder`,`fullpath`,`size`,`description`,`uploadtime`) VALUES ('%s', '%s','%s', '%s', '%s', '%s', '%s', '%s',%s, '%s',  NOW())",
mysql_real_escape_string($type, $db_connection),
mysql_real_escape_string($username, $db_connection),
mysql_real_escape_string($userid, $db_connection),
mysql_real_escape_string($userdisplayname, $db_connection),
mysql_real_escape_string($useremail, $db_connection),
mysql_real_escape_string($filename, $db_connection),
mysql_real_escape_string($folder, $db_connection),
mysql_real_escape_string($fullpath, $db_connection),
$size,
mysql_real_escape_string($description, $db_connection));
$update_log = mysql_query($query,$db_connection) or tfu_debug("Cound not insert data: " . $query);  
mysql_close($db_connection);                                       
}

/*
  This function is called when the tfu_file.php is called. e.g. for delete, download ...
*/
function db_plugin_process_file($action, $file, $folder) {
   // you can add all possible actions here 
  if ($action == "download" || $action == "zipdownload" || $action == "savetext" ||  
      $action == "delete" || $action == "xdelete" || $action == "createfile") {
    if ($action == "createfile") {
      $file = $folder . "/" . parseInputParameterFile(trim(my_basename(' ' . $_GET['newfile'])));
    }
    if (is_array($file)) {
      foreach ($file as $ff) {
        db_plugin_process_upload_file($folder, $ff ,basename($ff), $action);
      }
    } else {
      db_plugin_process_upload_file($folder, $file ,basename($file), $action);
    }
  } else if ($action == "renamedir" || $action == "deletedir" || $action == "createdir") {
    if ($action != "deletedir") { 
      $file = parseInputParameterFile(trim(my_basename(' ' . $_GET['newdir'])));  
    }
    db_plugin_process_upload_file($folder, '', $file, $action);  
  } else if ($action == "copymove") {
    // only from/to as tracked - for more details (like copy or move) you have to extend this by yourself! 
    $dest = getDestinationFolder(parseInputParameter($_GET['target'])); 
    foreach ($file as $ff) {
      db_plugin_process_upload_file($folder, $ff, $dest , $action);
    }
  }
}


/*
Below are internal functions you normaly don't have to modify!
*/
function add_column_if_not_exist($con, $db, $column, $column_attr = "TEXT" ){
    $exists = false;
    $columns = mysql_query('show columns from ' .$db,$con);
    while($c = mysql_fetch_assoc($columns)){
        if($c['Field'] == $column){
            $exists = true;
            break;
        }
    }      
    if(!$exists){
        mysql_query('ALTER TABLE ' . $db . ' ADD ' . $column . ' ' . $column_attr,$con);
    }
}

/* mysql_set_charset is not available before php 5.2.3 */
if (!function_exists('mysql_set_charset')) {
  function mysql_set_charset($charset,$dbh) { return mysql_query("set names $charset",$dbh); }}
/* To be compatible to old versions of TFU */
if (!function_exists('tfu_debug')) { function tfu_debug($str) { debug($str); } }
?>