<?php
/**
 * TWG Flash uploader 2.11.x
 *
 * Copyright (c) 2004-2010 TinyWebGallery
 * written by Michael Dempfle
 *
 * Name: Approve plugin
 * Description: This plugin moves a file to a subfolder called approve. This make it possible to make an easy approval process for uploads. Add the approve directory to the directories that are not shown in TWG and TFU/JFU. In TWG you can use the TWGExplorer to move the files back after approval. In JFU you can use a different profile where the directores are shown. 
 * Version Plugin: 1.0
 * Needed flash version: 2.13 
 *  
 * Feel free to adopt this to your needs.  
 */

defined('_VALID_TWG') or die('Direct Access to this location is not allowed.');

/**
 *  
 **/
function approve_plugin_process_upload_file($folder, $fullpath ,$filename) {
    global $exchangefilename, $dir_chmod;
    
    $userdir = $folder . '/approve';
    
    if (!file_exists($userdir)) {
      $result = mkdir($userdir);
      if ($result && $dir_chmod != 0) {
        @chmod($userdir, $dir_chmod);
      }
    }
    
    // in exchangefilename the new filename is passed back to tfu_upload.php - This is important for the further handling!
    $exchangefilename = $userdir .'/'. $filename;
    
    // If the file exists and the source is not the destinaion we delete the old one and move the file   
    if (file_exists($exchangefilename) && realpath($fullpath) != realpath($exchangefilename)) {
      @unlink($exchangefilename);
      @rename($fullpath, $exchangefilename);
    } else if (!file_exists($exchangefilename)) {
      @rename($fullpath, $exchangefilename);
    }
}
?>