<?php
/**
 * upload.php
 *
 * Copyright 2013, Moxiecode Systems AB
 * Released under GPL License.
 *
 * License: http://www.plupload.com/license
 * Contributing: http://www.plupload.com/contributing
 */

define('_VALID_TWG', '42');

$install_path = ''; // do not change!
$path_fix = '';     // do not change!
$store = 0;         // do not change!
$email_plugin = false; // do not change!

include 'tfu_session.php';
include 'tfu_config.php';

if ($enable_upload_debug) tfu_debug('1. Config loaded');

// check if login was done !
if ($_SESSION['TFU_LOGIN'] == true && $_SESSION["TFU_LOGIN_FRONTEND"] == true ) {

if ($enable_upload_debug) tfu_debug('2. Authenification sucessfull');
    
/* 
// Support CORS
header("Access-Control-Allow-Origin: *");
// other CORS headers if any...
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
	exit; // finish preflight CORS requests here
}
*/

// 5 minutes execution time
@set_time_limit(5 * 60);

// Uncomment this one to fake upload time
// usleep(5000);

// Settings
$targetDir = $_SESSION["tfu_upload_dir"];

//$targetDir = 'uploads';
$cleanupTargetDir = true; // Remove old files
$maxFileAge = 5 * 3600; // Temp file age in seconds


// Create target dir
if (!file_exists($targetDir)) {
	@mkdir($targetDir);
}

if (!is_writable($targetDir)) {
    die('{"jsonrpc" : "2.0", "error" : {"code": 105, "message": "The directory is not writeable. Please change the file permissions."}, "id" : "id"}');
}

// Get a file name
if (isset($_REQUEST["name"])) {
	$fileName = $_REQUEST["name"];
} elseif (!empty($_FILES)) {
	$fileName = $_FILES["file"]["name"];
} else {
	$fileName = uniqid("file_");
}

$filePath = $targetDir . DIRECTORY_SEPARATOR . $fileName;

// Chunking might be enabled
$chunk = isset($_REQUEST["chunk"]) ? intval($_REQUEST["chunk"]) : 0;
$chunks = isset($_REQUEST["chunks"]) ? intval($_REQUEST["chunks"]) : 0;


// Remove old temp files	
if ($cleanupTargetDir) {
	if (!is_dir($targetDir) || !$dir = opendir($targetDir)) {
		die('{"jsonrpc" : "2.0", "error" : {"code": 100, "message": "Failed to open temp directory."}, "id" : "id"}');
	}

	while (($file = readdir($dir)) !== false) {
		$tmpfilePath = $targetDir . DIRECTORY_SEPARATOR . $file;

		// If temp file is current file proceed to the next
		if ($tmpfilePath == "{$filePath}.part") {
			continue;
		}

		// Remove temp file if it is older than the max age and is not the current file
		if (preg_match('/\.part$/', $file) && (filemtime($tmpfilePath) < time() - $maxFileAge)) {
			@unlink($tmpfilePath);
		}
	}
	closedir($dir);
}	


// Open temp file
if (!$out = @fopen("{$filePath}.part", $chunks ? "ab" : "wb")) {
	die('{"jsonrpc" : "2.0", "error" : {"code": 102, "message": "Failed to open output stream."}, "id" : "id"}');
}

if (!empty($_FILES)) {
	if ($_FILES["file"]["error"] || !is_uploaded_file($_FILES["file"]["tmp_name"])) {
		die('{"jsonrpc" : "2.0", "error" : {"code": 103, "message": "Failed to move uploaded file."}, "id" : "id"}');
	}

	// Read binary input stream and append it to temp file
	if (!$in = @fopen($_FILES["file"]["tmp_name"], "rb")) {
		die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');
	}
} else {	
	if (!$in = @fopen("php://input", "rb")) {
		die('{"jsonrpc" : "2.0", "error" : {"code": 101, "message": "Failed to open input stream."}, "id" : "id"}');
	}
}

if ($enable_upload_debug) tfu_debug('3. Write file');
while ($buff = fread($in, 4096)) {
	fwrite($out, $buff);
}

@fclose($out);
@fclose($in);

if ($enable_upload_debug) tfu_debug('4. Check valid extension: ' . $fileName);
$is_valid = check_valid_extension($filePath, false);

if (!$is_valid) {
  header('HTTP/1.1 500 Internal Server Error');
  echo 'No valid extension - upload not permitted.';
  exit(0);
}
if ($enable_upload_debug) tfu_debug('4a. Extension valid.');

if ($normalise_file_names) {
  $fileName = normalizeFileNames($fileName);
}        
if ($enable_upload_debug) tfu_debug('5. file name normalized.');
$fileName = fix_decoding($fileName, $fix_utf8);    
$fileName = check_multiple_extensions($fileName, $remove_multiple_php_extension);

$filenameFull = $targetDir . DIRECTORY_SEPARATOR . $fileName;

if ($enable_upload_debug) tfu_debug('6. File name processing done: ' . $filename );

// Check if file has been uploaded
if (!$chunks || $chunk == $chunks - 1) {
	// Strip the temp .part suffix off 
	if (file_exists($filePath)) {
    @unlink($filePath);
  }
  @rename("{$filePath}.part", $filePath);
}

  // plugins are loaded here to do something after the upload - currently this is used for TWG. Other
  // plugins can be found on the website.
  if ($enable_upload_debug) tfu_debug('7. Internal processing done.');
  $plugins = glob("*_plugin.php");
  if ($plugins) {
    natsort($plugins);
    foreach ($plugins as $f) {
      if ($enable_upload_debug) tfu_debug('8. Execute plugin: ' . $f);
      include_once($f);
      $exchangefilename = $filenameFull;
      $store = 0; // if the plugin resize this variable has to be initialized!
      if (function_exists(basename ($f,".php"). "_process_upload_file")) {
        call_user_func(basename ($f,".php"). "_process_upload_file" , $targetDir, $filenameFull, $fileName);
      }
      if ($filenameFull != $exchangefilename) { // The plugin has changed the filename.
        $filenameFull = $exchangefilename; 
        $fileName = my_basename($exchangefilename);
      }                    
    }
    if ($enable_upload_debug) tfu_debug('8a. End plugins');
  }   
 
  removeCacheThumb($fileName);
  // this generates the two thumbnails of the preview
  // set this to true if you like this to be done at the upload an not on the fly.
  if (false) {
      send_thumb($filename, 90, 400, 275, true);
      send_thumb($filename, 90, 80, 55, true);
  }




} else {
  	die('{"jsonrpc" : "2.0", "error" : {"code": 104, "message": "Not logged in"}, "id" : "id"}');
}
// Return Success JSON-RPC response
die('{"jsonrpc" : "2.0", "result" : null, "id" : "id"}');
